## -*-Tcl-*- (nowrap)
 # ==========================================================================
 #  BibTeX mode - an extension package for Alpha
 # 
 #  FILE: "bibtexMenu.tcl"
 #                                    created: 08/17/9194 {09:12:06 am} 
 #                                last update: 08/13/2001 {16:23:17 PM}
 #                                
 #  Description: 
 #  
 #  Build the menu, subMenus for bibtex.
 #  
 #  See the "bibtexMode.tcl" file for license info, credits, etc.
 #  
 # ==========================================================================
 # 
 # The "Indices and Databases" menu items are contained in "bibtexData.tcl",
 # which should be loaded before this file to ensure that the "BibTeX Files" 
 # menu can be properly built.
 # 
 # ==========================================================================
 ## 

proc bibtexMenu.tcl {} {}

# load main bib file!
bibtexMenu

namespace eval Bib {}

# ===========================================================================
#
# Register Open Windows hook
# 
# Dim some menu items when there are no open windows.
# 

proc Bib::registerOWH {{which "register"}} {
    
    global BibmodeVars global::features Bib::Entries Bib::Fields
    
    # This is only necessary if the BibTeX Menu is global.
    if {![lcontains {global::features} bibtexMenu]} {return} 
    
    set menuItems {"entries" "fields" "sortBibFileBy" "sortBibMarks"}
    
    # Dim Entries and Fields items.
    foreach i [concat [set Bib::Entries] "customEntry"] {
        hook::$which requireOpenWindowsHook [list entries $i] 1
    } 
    foreach i [concat [set Bib::Fields] "customField" "multipleFields"] {
        hook::$which requireOpenWindowsHook [list fields $i] 1
    } 
    if {$BibmodeVars(hierarchicalMenu)} {
        lappend menuItems "navigating" "formatting"
        # Dim Navigating menu items.
        foreach i {"nextEntry" "prevEntry" "selectEntry" "copyCiteKey"} {
            hook::$which requireOpenWindowsHook [list navigating $i] 1
        } 
        # Dim Formatting menu items.
        foreach i {"formatEntry" "formatAllEntries" "validateEntry" "validateAllEntries"} {
            hook::$which requireOpenWindowsHook [list formatting $i] 1
        } 
        if {!$BibmodeVars(shortBibMenu)} {
            # Dim Searching menu items.
            foreach i {"searchEntries" "searchFields" "quickFindCitation"} {
                hook::$which requireOpenWindowsHook [list searching $i] 1
            } 
            # Dim Cite Key Lists menu items.
            foreach i {"countEntries" "findDuplicates" "listCiteKeys"} {
                hook::$which requireOpenWindowsHook [list citeKeyLists $i] 1
            } 
        } 
        if {$BibmodeVars(databaseMenuItems)} {
            # Dim Database menu items.
            foreach i {"addWinToDatabase" "addWinToIndex"} {
                hook::$which requireOpenWindowsHook [list databases $i] 1
            } 
        } 
    } else {
        lappend menuItems "nextEntry" "prevEntry" "selectEntry" "copyCiteKey"
        lappend menuItems "formatEntry" "formatAllEntries"
        lappend menuItems "validateEntry" "validateAllEntries"
        if {!$BibmodeVars(shortBibMenu)} {
            lappend menuItems "searchEntries" "searchFields" "quickFindCitation"
            lappend menuItems "countEntries" "findDuplicates" "listCiteKeys"
        }
        if {$BibmodeVars(databaseMenuItems)} {
            lappend menuItems "addWinToDatabase" "addWinToIndex"
        }
    } 
    lappend menuItems "bibtexConversions"
    
    foreach i $menuItems {
        hook::$which requireOpenWindowsHook [list "282" $i] 1
    } 
}

# ===========================================================================
# 
#  BibTeX Menu Definition  #
# 

menu::buildProc bibtexMenu              Bib::buildBibMenu
menu::buildProc entries                 Bib::buildEntriesMenu
menu::buildProc fields                  Bib::buildFieldsMenu
menu::buildProc citeKeyLists            Bib::buildCiteKeysMenu
menu::buildProc bibModeAcronyms         Bib::buildBibAcronymsMenu
menu::buildProc defaultEntryFields      Bib::buildEntryFieldsMenu
menu::buildProc bibtexConversions       Bib::buildBibConversionsMenu

set menu::posteval(bibtexMenu) {Bib::postEval}

proc Bib::buildBibMenu {} {
    
    global PREFS bibtexMenu BibmodeVars menu::additions Bib::FileTails
    global Bib::Entries Bib::Fields Bib::PrefsInMenu1 Bib::PrefsInMenu2
    
    # Needed to know whether we should dim some menu items.
    if {[llength [set Bib::FileTails]]} {set dim ""} else {set dim "\("}
    
    set menuList {"<U<O/-bibtexApplication" "bibtexHomePage"}
    set subMenus ""
    # Include the "Bib Files Menu" only if the databaseMenuItems pref is set.
    if {$BibmodeVars(databaseMenuItems)} {
        set fileList [list \
          "rebuildFileList" "${dim}openAllBibFiles" "${dim}closeAllBibFiles"]
        if {$dim == ""} {
            lappend fileList "(-)"
            # Create the list of .bib files
            foreach bibfile [set Bib::FileTails] {lappend fileList "\ ${bibfile}&"}
        } 
        lappend menuList [list \
          Menu -n bibtexFileList -p Bib::fileListProc -M Bib $fileList]
    } 
    lappend menuList "(-)"
    # Add the Entries and Fields menus.  Note that these also have their
    # own build procs, so that these can be rebuilt on the fly.
    set entriesList [concat [set Bib::Entries] "(-)" "customEntry"]
    set fieldsList  [concat [set Bib::Fields]  "(-)" "customField" "multipleFields"]
    lappend menuList [list \
      Menu -n entries -p Bib::entriesProc -M Bib $entriesList]
    lappend menuList [list\
      Menu -n fields -p Bib::fieldsProc -M Bib $fieldsList] "(-)"
    # Add the Navigation, Formatting, Searching menus.
    set navigationList {
        "<U<B/NnextEntry"   "<U<B/PprevEntry"
        "<U<B/SselectEntry" "<U<B/CcopyCiteKey"
    }
    set searchList [list \
      "<U<B/EsearchEntries"           "<U<B/FsearchFields"   \
      "<U<B/B${dim}searchAllBibFiles" "<O<B/QquickFindCitation" \
      ]
    if {$BibmodeVars(hierarchicalMenu)} {
        set formatList {
            "<U<B/LformatEntry"   "<O<U<B/LformatAllEntries" "(-)"
            "<U<B/VvalidateEntry" "<O<U<B/VvalidateAllEntries"
        }
      
        lappend menuList \
	  [list Menu -n navigating -p Bib::menuProc -M Bib $navigationList]
        lappend menuList \
	  [list Menu -n formatting -p Bib::menuProc -M Bib $formatList]
        if {!$BibmodeVars(shortBibMenu)} {
            lappend menuList \
	      [list Menu -n searching -p Bib::menuProc -M Bib  $searchList]
            lappend menuList \
	      [list Menu -n citeKeyLists -M Bib {}]
            lappend subMenus "citeKeyLists"
        } 
        lappend menuList "(-)"
    } else {
        set formatList {
            "<E<S<U<B/LformatEntry"   "<S<O<U<B/LformatAllEntries"
            "<E<S<U<B/VvalidateEntry" "<S<O<U<B/VvalidateAllEntries"
        }
        append  menuList $navigationList " (-)" $formatList " (-)"
        if {!$BibmodeVars(shortBibMenu)} {
            append  menuList " $searchList" " (-)"
            lappend menuList \
              "<E<ScountEntries"   "<S<O${dim}countAllEntries"        \
              "<E<SfindDuplicates" "<S<O${dim}findAllDuplicates"      \
              "<E<SlistCiteKeys"   "<S<O${dim}listAllCiteKeys"         \
              "(-)"
        } 
    } 
    # Add the "Sort Bib File By" and "Sort Marks By" menus.
    set sortList {
        "citeKey" "firstAuthor,Year" "lastAuthor,Year"
        "year,FirstAuthor" "year,LastAuthor"
    }
    set marksList {"alphabetically" "byPosition"}
    lappend menuList \
      [list Menu -n sortBibFileBy -p Bib::sortFileByProc -M Bib $sortList]
    lappend menuList \
      [list Menu -n sortBibMarks  -p Bib::sortMarksProc  -M Bib  $marksList]
    # Add the "Bibtex Conversions" menu if long menu.
    lappend menuList [list Menu -n bibtexConversions -M Bib {}]
    # We make sure that this menu at least exists ...
    lappend subMenus "bibtexConversions"
    lappend menuList "(-)"
    # Add the "Default Entry Fields" and "Bib Mode Options" menus.
    lappend menuList [list Menu -n defaultEntryFields -M Bib {}]
    lappend menuList \
      [list Menu -n bibModeOptions -p Bib::optionsProc -M Bib [set Bib::PrefsInMenu1]]
    lappend subMenus "defaultEntryFields"
    if {!$BibmodeVars(shortBibMenu)} {
        lappend menuList [list Menu -n bibModeAcronyms -M Bib {}]
        lappend subMenus "bibModeAcronyms"
    }
    if {$BibmodeVars(databaseMenuItems)} {
        if {[file exists [file join $PREFS bibIndex]]} {
            set dim1 ""
            set re1  "re"
        } else {
            set dim1 "("
            set re1  ""
        }
        if {[file exists [file join $PREFS bibDatabase]]} {
            set dim2 ""
            set re2  "re"
        } else {
            set dim2 "("
            set re2  ""
        }
        # Add the Bib Files menu.
	set fileOptions [concat \
	  "listAllBibliographies" "(-)" [set Bib::PrefsInMenu2]]
        lappend menuList \
	  [list Menu -n bibModeFiles -p Bib::fileOptionsProc -M Bib $fileOptions] "(-)"
        # Add the Database menu items.
        if {$BibmodeVars(hierarchicalMenu)} {
            set dataList [list \
              "${re1}buildIndex" "${dim1}reviewIndex" "${dim1}removeIndex" "(-)" \
              "addWinToIndex" "addFilesToIndex" "(-)" "${re2}buildDatabase" \
              "${dim2}reviewDatabase" "${dim2}removeDatabase" "(-)" \
              "addWinToDatabase" "addFilesToDatabase" \
              ]
            lappend menuList [list \
              Menu -n databases -p Bib::menuProc -M Bib $dataList]
        } else {
            lappend menuList \
              "<E<S${re1}buildIndex"     "<S<O${dim1}reviewIndex"       \
              "<S<B${dim1}removeIndex"                                  \
              "<E<S${re2}buildDatabase" "<S<O${dim2}reviewDatabase"     \
              "<S<B${dim2}removeDatabase" "(-)"                         \
              "<E<SaddWinToIndex"    "<S<OaddFilesToIndex"             \
              "<E<SaddWinToDatabase" "<S<OaddFilesToDatabase"          
        }
    }
    Bib::registerOWH
    return [list "build" $menuList {Bib::menuProc -M Bib} $subMenus $bibtexMenu]
}

# Previous "Entries" definitions:
# 
# set menu::items(entries) [concat [set Bib::DefaultEntries] "(-)" "customEntry"]
# set menu::proc(entries)  Bib::entryProc
# 
# (But now we want the ability to rebuild this...)
# 

proc Bib::buildEntriesMenu {} {
    
    global Bib::Entries
    
    set entriesList [concat [set Bib::Entries] "(-)" "customEntry"]
    
    return [list build $entriesList Bib::entriesProc {}]
}

# Previous "Fields" definitions:
# 
# set menu::items(fields)  [concat [set Bib::DefaultFields] "(-)" "customField" "multipleFields"]
# set menu::proc(fields)   Bib::fieldProc
# 
# (But now we want the ability to rebuild this...)
# 

proc Bib::buildFieldsMenu {} {
    
    global Bib::Fields
    
    set fieldsList [concat [set Bib::Fields] "(-)" "customField" "multipleFields"]
    
    return [list build $fieldsList Bib::fieldsProc {}]
}

proc Bib::buildCiteKeysMenu {} {
    
    global BibmodeVars Bib::CiteKeys Bib::Files
    
    set citeKeyFiles ""
    set citeKeyFiles [lsort [lunique [lindex [set Bib::CiteKeys] 2]]]
    if {[llength [set Bib::Files]]} {set dim1 ""} else {set dim1 "("}
    if {[llength $citeKeyFiles]}    {set dim2 ""} else {set dim2 "("}
    set citeKeyList [list \
        "countEntries" "findDuplicates" "listCiteKeys" "(-)"            \
        "${dim1}countAllEntries" "${dim1}findAllDuplicates"           \
        "${dim2}listAllCiteKeys" "(-)"                                  \
        "${dim1}createCiteKeyList" "${dim2}clearCiteKeyList" "(-)"     \
        ]
    if {$dim2 == "("} {
        lappend citeKeyList "(noCiteKeysSaved"
    } else {
        foreach fileTail $citeKeyFiles {
            lappend citeKeyList "${fileTail}&"
        }
    }
    return [list build $citeKeyList Bib::citeKeysProc {}]
}

proc Bib::buildBibConversionsMenu {} {
    
    global menu::additions
    
    set menuList ""

    return [list build $menuList Bib::menuProc {}]
}

proc Bib::buildEntryFieldsMenu {} {
    
    global BibmodeVars Bib::CustomEntryList Bib::CustomEntryList1 Bib::CustomEntryList2
    global Bib::MyFlds Bib::Entries alpha::platform
    
    if {${alpha::platform} == "alpha"} {
            set prefix "!*"
    } else {
            set prefix "!"
    } 
    foreach entryName [set Bib::Entries] {
        if {[info exists Bib::MyFlds($entryName)] || $entryName == "string"} {
            # We take any Bib::MyFlds() custom entries into account (which we
            # cannot modify).
            lappend menuList "($entryName"
        } elseif {[lsearch [set Bib::CustomEntryList] $entryName] == "-1"} {
            lappend menuList "$entryName"
        } else {
            lappend menuList "${prefix}$entryName"
        } 
    }
    lappend menuList "(-)"
    # Add the following only if there are custom<EntryName> prefs.
    # We don't count user defined entries.
    if {[llength [set Bib::CustomEntryList2]]} {
        lappend menuList "restoreDefaultFields"
    } else {
        lappend menuList "(restoreDefaultFields"
    }
    # Add the following only if there are user defined entries.
    if {[llength [set Bib::CustomEntryList1]]} {
        lappend menuList "removeCustomEntry"
    } else {
        lappend menuList "(removeCustomEntry"
    }
    lappend menuList "editCustomFields"
    
    return [list build $menuList Bib::entryFieldsProc {}]
}

proc Bib::buildBibAcronymsMenu {} {
    
    global BibmodeVars Bib::AcronymsSet Bib::Acronyms

    set menuList {"viewAcronyms" "addAcronyms" "editAcronyms"}
    set dim "("
    foreach acronym [array names Bib::Acronyms] {
        if {![info exists Bib::AcronymsSet($acronym)]} {
            # We know that this is user defined.
            set dim ""
            break
        } elseif {[set Bib::Acronyms($acronym)] != [set Bib::AcronymsSet($acronym)]} {
            # We know that this has not been redefined.
            set dim ""
            break
        } 
    } 
    lappend menuList "${dim}removeAcronyms" "(-)"
    if {!$BibmodeVars(unsetAcronymList)} {
        lappend menuList "unsetAcronymList"
    } else {
        lappend menuList "resetAcronymList"
    } 
    lappend menuList "checkKeywords" "bibModeTutorial"
    
    return [list build $menuList Bib::acronymsProc {}]
}

# ===========================================================================
# 
# Post Evaluate -- dim or mark menu items as necessary.
# 

proc Bib::postEval {args} {
    
    global Bib::PrefsInMenu1 Bib::PrefsInMenu2 BibmodeVars
    
    foreach item [set Bib::PrefsInMenu1] {
	if {$item == "(-)"} {continue}
	markMenuItem {bibModeOptions} $item $BibmodeVars($item) 
    }
    if {$BibmodeVars(databaseMenuItems)} {
	foreach item [set Bib::PrefsInMenu2] {
	    if {$item == "(-)"} {continue}
	    markMenuItem {bibModeFiles} $item $BibmodeVars($item) 
	}
    }
}

# Now we actually build the menu.

menu::buildSome bibtexMenu ; requireOpenWindowsHook 1

# ===========================================================================
# 
#  BibTeX Menu Support  #
# 

proc Bib::rebuildMenu {args} {
    
    if {![llength $args]} {set args "bibtexMenu"}
    foreach menuName $args {
        if {$menuName == "bibtexMenu"} {
            status::msg "Rebuilding the BibTeX menu "
            Bib::registerOWH "deregister"
            menu::buildSome "bibtexMenu"
            status::msg ""
        } else {
            catch {menu::buildSome $menuName}
        }
    }
    requireOpenWindowsHook 1
}

# ===========================================================================
# 
# BibTeX menu proc
# 
# This is the procedure called for all main menu items.
# 
# Note: (from "Bugs and Bug Reporting:)
# 
#       Half-fixed:
# 
# When dealing with a menu with more than perhaps 20 items, Alpha won't
# unconvert the menu-item when it is sent to the menu-proc.  So if I build
# a menu with 'Menu -n Name -p my_proc {lots of items...  thisOne}' then
# 'thisOne' appears in the menu as 'This One' (as desired), but when it is
# selected, the call is 'my_proc Name "This One"' which is incorrect.  The
# menu items near the top of the menu work fine!
# 

proc Bib::menuProc {menu item} {
    
    if {$item == "buildIndex" || $item == "Build Index"} {
        Bib::buildIndex 1
    } elseif {$item == "rebuildIndex" || $item == "Rebuild Index"} {
        Bib::rebuildIndex 1
    } elseif {$item == "reviewIndex" || $item == "Review Index"} {
        Bib::reviewIndexOrDatabase "bibIndex"
    } elseif {$item == "removeIndex" || $item == "Remove Index"} {
        Bib::removeIndexOrDatabase "bibIndex"
    } elseif {$item == "buildDatabase" || $item == "Build Database"} {
        Bib::buildDatabase 1
    } elseif {$item == "rebuildDatabase" || $item == "Rebuild Database"} {
        Bib::rebuildDatabase 1
    } elseif {$item == "reviewDatabase" || $item == "Review Database"} {
        Bib::reviewIndexOrDatabase "bibDatabase"
    } elseif {$item == "removeDatabase" || $item == "Remove Database"} {
        Bib::removeIndexOrDatabase "bibDatabase"
    } elseif {$item == "addWinToIndex" || $item == "Add Win To Index"} {
        Bib::addWinToIndex
    } elseif {$item == "addFilesToIndex" || $item == "Add Files To Index"} {
        Bib::addWinToIndex "-1"
    } elseif {$item == "addWinToDatabase" || $item == "Add Win To Database"} {
        Bib::addWinToDatabase
    } elseif {$item == "addFilesToDatabase" || $item == "Add Files To Database"} {
        Bib::addWinToDatabase "-1"
    } else {
        Bib::$item
    } 
}

# No longer used, since all of the items are contained in the namespace Bib.

# proc Bib::menuProc {menu item} {
#     menu::generalProc Bib $item 0
# }

# ===========================================================================
# 
# "Bib::optionsProc" --
# 
# Toggle Bib mode preferences.
# 

proc Bib::optionsProc {menuName item} {
    
    global BibmodeVars Bib::PrefsInMenu1 alpha::platform flag::procs
    
    if {$menuName == "bibModeOptions" && [getModifiers]} {
	cache::readContents index::prefshelp
	if {[catch {set prefshelp(Bib,$item)} text]} {
	    set text "Sorry, no information is available for '$item'"
	} else {
	    catch {unset index::prefshelp}
	}
	if {$BibmodeVars($item)} {set end "on"} else {set end "off"}
	if {$end == "on"} {
	    regsub {^.*\|\|} $text {} text
	} else {
	    regsub {\|\|.*$} $text {} text
	}
	append text "."
	set msg "The '$item' preference for Bib mode is currently $end."
    } elseif {$item == "bibModeHelp"} {
	package::helpFile "Bib"
    } elseif {[lcontains Bib::PrefsInMenu1 $item]} {
	Bib::flagFlip $item
	# Any message?
	if {[regexp {Menu} $item]} {
	    if {$item == "hierarchicalMenu"} {
		if {$BibmodeVars($item)} {
		    set msg "The BibTeX menu is now hierarchical."
		} elseif {${alpha::platform} == "alpha"} {
		    set msg "Use the command key to access dynamic BibTeX menu items."
		} else {
		    set msg "Most items are now in the main BibTeX menu."
		}
	    } elseif {$item == "shortBibMenu"} {
		if {$BibmodeVars($item)} {
		    set msg "The BibTeX menu is now short."
		} else {
		    set msg "The BibTeX menu is now long."
		} 
	    } elseif {$item == "databaseMenuItems"} {
		if {$BibmodeVars($item)} {
		    set msg "The BibTeX Files menu items are now in the BibTeX menu."
		} else {
		    set msg "The BibTeX Files menu items are no longer in the BibTeX menu."
		} 
	    }
	} elseif {$BibmodeVars($item)} {
	    set msg "The \"$item\" preference is currently on."
	} else {
	    set msg "The \"$item\" preference is currently off."
	}
    } else {
	Bib::$item
    } 
    if {[info exists text]} {alertnote $text}
    if {[info exists msg]}  {status::msg $msg}
}

# ===========================================================================
# 
# "Bib::BibModeMenuItem" --
# 
# Gives the user an alertnote if Alpha called a Bib proc for a window that
# is not in Bib mode (a known bug).
# 

proc Bib::BibModeMenuItem {{requireWindow 1}} {
    
    global mode
    
    if {$requireWindow && ![llength [winNames]]} {
        dialog::alert "This menu item requires an open window."
        return -code return
    } elseif {$mode != "Bib"} {
        dialog::alert "You might have encountered a known key-binding bug,\
          in which case you must use the menu bar.  Otherwise, you\
          selected a menu item that is only applicable to .bib files !"
        return -code return
    } 
}

# ===========================================================================
# 
# .
